/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.compat.ExtraConfigManager;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.util.CopyOnWriteHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerConfigManager
implements class_4013 {
    private static final Map<class_2960, ServerConfigHolder> CONFIGS = new CopyOnWriteHashMap<class_2960, ServerConfigHolder>();

    public static void registerServerConfig(AbstractConfigContainer data, PermissionChecker checker) {
        ServerConfigManager.registerServerConfig(data, checker, false);
    }

    public static void registerServerConfig(AbstractConfigContainer data, PermissionChecker checker, boolean allowManualSync) {
        CONFIGS.put(data.getConfigId(), new ServerConfigHolder(data, checker, allowManualSync));
    }

    @Nullable
    public static AbstractConfigContainer getConfig(class_2960 id) {
        ServerConfigHolder holder = CONFIGS.get(id);
        if (holder == null) {
            return null;
        }
        return holder.data;
    }

    public static boolean checkPermission(class_2960 id, MinecraftServer server, class_3222 player, boolean modify) {
        ServerConfigHolder holder = CONFIGS.get(id);
        if (holder == null) {
            return false;
        }
        return !modify && holder.allowManualSync || holder.checker.check(server, player);
    }

    public static List<AbstractConfigContainer> getServerConfigs() {
        return CONFIGS.values().stream().map(ServerConfigHolder::data).toList();
    }

    public void method_14491(@NotNull class_3300 manager) {
        CONFIGS.values().forEach(x -> x.data.load());
        ExtraConfigManager.scanConfigs();
        Jupiter.LOGGER.info("Successfully reload {} server config(s).", (Object)CONFIGS.size());
    }

    @FunctionalInterface
    public static interface PermissionChecker {
        public static final PermissionChecker ALWAYS_TRUE = (server, player) -> true;
        public static final PermissionChecker ALWAYS_FALSE = (server, player) -> false;
        public static final PermissionChecker IS_DEDICATE_SERVER = (server, player) -> server.method_3816();
        public static final PermissionChecker IS_LOCAL_GAME = (server, player) -> !IS_DEDICATE_SERVER.check(server, player);
        public static final PermissionChecker IS_OPERATOR = (server, player) -> IS_LOCAL_GAME.check(server, player) || player.method_5687(server.method_3798());

        public boolean check(MinecraftServer var1, class_3222 var2);
    }

    private record ServerConfigHolder(AbstractConfigContainer data, PermissionChecker checker, boolean allowManualSync) {
    }
}

